<?php
   header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Content-Security-Policy: default-src 'self';");
   require APPPATH . '/libraries/REST_Controller.php';
   use Restserver\Libraries\REST_Controller;
     
class Delivery extends REST_Controller {
    
	  /**
     * Get All Data from this method.
     *
     * @return Response
    */
    public function __construct() {
       parent::__construct();
       $this->load->database();
    }
       
    /**
     * Get All Data from this method.
     *
     * @return Response
    */
	public function index_get($id = 0,$date = "",$tdate="",$delivery = "")
	{
	    $index = 0;
	    if(empty($tdate)){
	        $tdate = $date;
	    }
	    $sql = "SELECT * FROM DeliveryHeader JOIN DeliveryCompany ON DeliveryHeader.DeliId = DeliveryCompany.DeliId " 
	           ."WHERE ((DeliveryHeader.DeliDateTime BETWEEN '".$date."' AND DATE_ADD('".$tdate."', INTERVAL 1 DAY)) " 
	          ."OR ('".$date."' = '')) AND ((DeliveryCompany.DeliName LIKE '%".rawurldecode($delivery)."%') OR ('".$delivery."'='')) AND ((DeliveryHeader.DeliHeaderId = ".$id.") OR (".$id."=0)) AND DeliveryHeader.IsDeleted=0";
        $deliHead = $this->db->query($sql)->result();
        $data = null;
        foreach ($deliHead as $dHead){
            $delDets = $this->db->query("SELECT DeliDetailId, DeliHeaderId, SaleHeaderId, CustomerId,
CustomerName,CustomerPhone, CustomerAddress, CustomerTownship, 
VoucherTotal, DeliFee,PaymentMethodId FROM DeliveryDetail WHERE DeliHeaderId=".$dHead->DeliId)->result();
            $data[$index] = array(
                'DeliHeaderId' => $dHead->DeliHeaderId,
                'DeliName' => $dHead->DeliName,
                'DeliDocNo' => $dHead->DeliDocNo,
                'DeliDateTime' => $dHead->DeliDateTime,
                'DeliId' => $dHead->DeliId,
                'DeliRemark' => $dHead->DeliRemark,
                'CreatedDateTime' => $dHead->CreatedDateTime,
                'CreatedBy' => $dHead->CreatedBy,
                'TotalItemPrice' => $dHead->TotalItemPrice,
                'TotalDeliFees' => $dHead->TotalDeliFees,
                'DeliPaid' => $dHead->DeliPaid,
                'DeliveryDetail' => $delDets);
            
            $index++;
        }
     
        $this->response($data, REST_Controller::HTTP_OK);
	}
      
    /**
     * Get All Data from this method.
     *
     * @return Response
    */
    public function index_post($type)
    {
        if($type==='new'){
            $input = $this->input->post();
            $DeliHeader = array(
                    'DeliHeaderId' => $input['DeliHeaderId'],
                    'DeliName' => $input['DeliName'],
                    'DeliDocNo' => $input['DeliDocNo'],
                    'DeliDateTime' => $input['DeliDateTime'],
                    'DeliId' => $input['DeliId'],
                    'CreatedDateTime' => date("Y-m-d H:i:s"),
                    'CreatedBy' => $input['CreatedBy'],
                    'TotalVoucherAmount' => $input['TotalVoucherAmount'],
                    'TotalDeliFees' => $input['TotalDeliFees'],
                    'DeliPaid' => $input['DeliPaid'],
                    'DeliRemark' => $input['DeliRemark']
            );
            $this->db->insert('DeliveryHeader',$DeliHeader);
            $insert_id = $this->db->insert_id();
            
            foreach ($input['DeliveryDetail'] as $rowDet) {
                $delDet = array(
                        'DeliHeaderId' => $insert_id,
                        'DeliDetailId'=> '0',
                        'SaleHeaderId' => $rowDet['SaleHeaderId'],
                        'CustomerId' => $rowDet['CustomerId'],
                        'CustomerName' => $rowDet['CustomerName'],
                        'CustomerPhone' => $rowDet['CustomerPhone'],
                        'CustomerAddress' => $rowDet['CustomerAddress'],
                        'CustomerTownship' => $rowDet['CustomerTownship'],
                        'VoucherAmount' => $rowDet['VoucherAmount'],
                        'DeliFee' => $rowDet['DeliFee'],
                        'PaymentMethodId' => $rowDet['PaymentMethodId'],
                        'IsPaid' =>  $rowDet['IsPaid'],
                );
                
                $this->db->insert('DeliveryDetail',$delDet);
            }
            $this->response(['Delivery created successfully.'], REST_Controller::HTTP_OK);
        }
        else if ($type==='update'){
            $input = $this->input->post();
            $DeliHeader = array(
                    'DeliHeaderId' => $input['DeliHeaderId'],
                    'DeliName' => $input['DeliName'],
                    'DeliDocNo' => $input['DeliDocNo'],
                    'DeliDateTime' => $input['DeliDateTime'],
                    'DeliId' => $input['DeliId'],
                    'CreatedDateTime' => date("Y-m-d H:i:s"),
                    'CreatedBy' => $input['CreatedBy'],
                    'TotalVoucherAmount' => $input['TotalVoucherAmount'],
                    'TotalDeliFees' => $input['TotalDeliFees'],
                    'DeliPaid' => $input['DeliPaid'],
                    'DeliRemark' => $input['DeliRemark']
            );
            $this->db->update('DeliveryHeader', $DeliHeader, array('DeliHeaderId'=>$input['DeliHeaderId']));
            $this->db->delete('DeliveryDetail', array('DeliHeaderId'=>$input['DeliHeaderId']));
            foreach ($input['DeliveryDetail'] as $rowDet) {
                $delDet = array(
                        'DeliHeaderId' => $insert_id,
                        'DeliDetailId'=> '0',
                        'SaleHeaderId' => $rowDet['SaleHeaderId'],
                        'CustomerId' => $rowDet['CustomerId'],
                        'CustomerName' => $rowDet['CustomerName'],
                        'CustomerPhone' => $rowDet['CustomerPhone'],
                        'CustomerAddress' => $rowDet['CustomerAddress'],
                        'CustomerTownship' => $rowDet['CustomerTownship'],
                        'VoucherAmount' => $rowDet['VoucherAmount'],
                        'DeliFee' => $rowDet['DeliFee'],
                        'PaymentMethodId' => $rowDet['PaymentMethodId'],
                        'IsPaid' =>  $rowDet['IsPaid'],
                );
                
                $this->db->insert('DeliveryDetail',$delDet);
            }
         
            $this->response(['Delivery updated successfully.'], REST_Controller::HTTP_OK);
        }else if ($type==='delete') {
            $input = $this->input->post();
            $this->db->delete('DeliveryHeader',  array('DeliHeaderId'=>$input['DeliHeaderId']));
            $this->db->delete('DeliveryDetail',  array('DeliHeaderId'=>$input['DeliHeaderId']));
            
            $this->response(['Delivery delete successfully.'], REST_Controller::HTTP_OK);
        }
        
         
        
    } 
     
    /**
     * Get All Data from this method.
     *
     * @return Response
    */
    public function index_put($id)
    {
        $input = $this->put();
        $this->db->update('products', $input, array('id'=>$id));
     
        $this->response(['Product updated successfully.'], REST_Controller::HTTP_OK);
    }
     
    /**
     * Get All Data from this method.
     *
     * @return Response
    */
    public function index_delete($id)
    {
        $this->db->delete('products', array('id'=>$id));
       
        $this->response(['Product deleted successfully.'], REST_Controller::HTTP_OK);
    }
    	
}