<?php
   header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, DELETE, PUT, PATCH, OPTIONS');
header("Content-Security-Policy: default-src 'self';");
   require APPPATH . '/libraries/REST_Controller.php';
   use Restserver\Libraries\REST_Controller;
     
class Supplier extends REST_Controller {
    
	  /**
     * Get All Data from this method.
     *
     * @return Response
    */
    public function __construct() {
       parent::__construct();
       $this->load->database();
    }
       
    /**
     * Get All Data from this method.
     *
     * @return Response
    */
	public function index_get($id = 0,$isActive = 9, $name = '')
	{
	    $sql="SELECT * FROM Supplier WHERE (SupplierId = ".$id." OR 0=".$id.") AND (SupplierName LIKE '%".rawurldecode($name)."%' OR ''='".rawurldecode($name)."') AND (IsActive=".$isActive." OR ".$isActive."=9) AND IsDeleted=0 ORDER BY SupplierId DESC";
        
        $data = $this->db->query($sql)->result();
     
        $this->response($data, REST_Controller::HTTP_OK);
	}
      
    /**
     * Get All Data from this method.
     *
     * @return Response
    */
    public function index_post($type)
    {
        if($type==='new'){
            $input = $this->input->post();
            $supplier = array(
                    'SupplierId' => $input['SupplierId'],
                    'SupplierName' => $this->db->escape_str($input['SupplierName']),
                    'SupplierPhone' => $this->db->escape_str($input['SupplierPhone']),
                    'SupplierAddress' => $this->db->escape_str($input['SupplierAddress']),
                    'SupplierRemark' => $this->db->escape_str($input['SupplierRemark']),
                    'IsActive' => intval($input['IsActive']),
                    'IsDeleted' =>  0,
                    'CreatedDateTime' => date("Y-m-d H:i:s"),
                    'CreatedBy' => $input['CreatedBy']
            );
            $this->db->insert('Supplier',$supplier);
            $this->response(['Supplier created successfully.'], REST_Controller::HTTP_OK);
        }
        else if ($type==='update'){
            $input = $this->input->post();
            $supplier = array(
                    'SupplierId' => $input['SupplierId'],
                    'SupplierName' => $this->db->escape_str($input['SupplierName']),
                    'SupplierPhone' => $this->db->escape_str($input['SupplierPhone']),
                    'SupplierAddress' => $this->db->escape_str($input['SupplierAddress']),
                    'SupplierRemark' => $this->db->escape_str($input['SupplierRemark']),
                    'IsActive' => intval($input['IsActive']),
                    'IsDeleted' =>  0,
                    'CreatedDateTime' => date("Y-m-d H:i:s"),
                    'CreatedBy' => $input['CreatedBy']
            );
            $this->db->update('Supplier', $supplier, array('SupplierId'=>$input['SupplierId']));
         
            $this->response(['Supplier updated successfully.'], REST_Controller::HTTP_OK);
        }else if ($type==='delete') {
            $input = $this->input->post();
            $supplier = array(
                    'IsDeleted' => 1,
                    'CreatedDateTime' => date("Y-m-d H:i:s")
            );
            $this->db->update('Supplier', $supplier, array('SupplierId'=>$input['SupplierId']));
         
            $this->response(['Supplier delete successfully.'], REST_Controller::HTTP_OK);
        }
    } 
     
    /**
     * Get All Data from this method.
     *
     * @return Response
    */
    public function index_put($id)
    {
        $input = $this->put();
        $this->db->update('Customer', $input, array('CustomerId'=>$id));
     
        $this->response(['Customer updated successfully.'], REST_Controller::HTTP_OK);
    }
     
    /**
     * Get All Data from this method.
     *
     * @return Response
    */
    public function index_delete($id)
    {
        //$this->db->delete('Customer', array('CustomerId'=>$id));
       
        //$this->response(['Customer deleted successfully.'], REST_Controller::HTTP_OK);
         $this->response([$id], REST_Controller::HTTP_OK);
    }
    	
}