<?php
   header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Content-Security-Policy: default-src 'self';");
   require APPPATH . '/libraries/REST_Controller.php';
   use Restserver\Libraries\REST_Controller;
     
class SaleItem extends REST_Controller {
    
	  /**
     * Get All Data from this method.
     *
     * @return Response
    */
    public function __construct() {
       parent::__construct();
       $this->load->database();
    }
       
    /**
     * Get All Data from this method.
     *
     * @return Response
    */
	public function index_get($id = 0,$isActive=9, $currentPage = 0, $name = '')
	{
	    $offsetRecords = 0;
	    if($currentPage > 0)
	        $offsetRecords = 10*($currentPage-1);
	    
	    $sql="SELECT * FROM Item WHERE (ItemId = ".$id." OR 0=".$id.") AND (IsActive = ".$isActive." OR ".$isActive."=9) AND (ItemName LIKE '%".rawurldecode($name)."%' OR ''='".rawurldecode($name)."') AND IsDeleted=0 LIMIT ".$offsetRecords.", 10";
	    
        
        $data = $this->db->query($sql)->result();
        
        
     
        $this->response($data, REST_Controller::HTTP_OK);
	}
      
    /**
     * Get All Data from this method.
     *
     * @return Response
    */
    public function index_post($type)
    {
        if($type==='new'){
            $input = $this->input->post();
            
            $item = array(
                    'ItemId' => $input['ItemId'],
                    'ItemName' => $input['ItemName'],
                    'CatId' => $input['CatId'],
                    'ItemPrice' => $input['ItemPrice'],
                    'ItemCost' => $input['ItemCost'],
                    'ItemNote' => $input['ItemNote'],
                    'ItemWsPrice' =>  $input['ItemWsPrice'],
                    'BizId' => $input['BizId'],
                    'IsActive' => intval($input['IsActive']),
                    'IsDeleted' => 0,
                    'CreatedDateTime' => date("Y-m-d H:i:s"),
                    'CreatedBy' => $input['CreatedBy']
            );
            $this->db->insert('Item',$item);
            $this->response(['Item created successfully.'], REST_Controller::HTTP_OK);
        }
        else if ($type==='update'){
            $input = $this->input->post();
            $item = array(
                    'ItemId' => $input['ItemId'],
                    'ItemName' => $input['ItemName'],
                    'CatId' => $input['CatId'],
                    'ItemPrice' => $input['ItemPrice'],
                    'ItemCost' => $input['ItemCost'],
                    'ItemNote' => $input['ItemNote'],
                    'ItemWsPrice' =>  $input['ItemWsPrice'],
                    'BizId' => $input['BizId'],
                    'IsActive' => intval($input['IsActive']),
                    'IsDeleted' => 0,
                    'CreatedDateTime' => date("Y-m-d H:i:s"),
                    'CreatedBy' => $input['CreatedBy']
            );
            $this->db->update('Item', $item, array('ItemId'=>$input['ItemId']));
         
            $this->response(['Item updated successfully.'], REST_Controller::HTTP_OK);
        }else if ($type==='delete') {
            $input = $this->input->post();
            $item = array(
                    'IsDeleted' => 1,
                    'CreatedDateTime' => date("Y-m-d H:i:s")
            );
            $this->db->update('Item', $item, array('ItemId'=>$input['ItemId']));
         
            $this->response(['Item delete successfully.'], REST_Controller::HTTP_OK);
        }
    } 
     
}